﻿using System;
using System.IO;
using System.Net;
using System.Text;
using System.Net.Security;
using System.Security.Cryptography;
using System.Security.Cryptography.X509Certificates;

namespace PubKeyPin
{
    class Program
    {
        // DER encoded public key
        private static String PUB_KEY = "3082010A0282010100B35EA8ADAF4CB6" +
            "DB86068A836F3C855A545B1F0CC8AFB19E38213BAC4D55C3F2F19DF6DEE8" +
            "2EAD67F70A990131B6BCAC1A9116ACC883862F00593199DF19CE027C8EAA" +
            "AE8E3121F7F329219464E6572CBF66E8E229EAC2992DD795C4F23DF0FE72" +
            "B6CEEF457EBA0B9029619E0395B8609851849DD6214589A2CEBA4F7A7DCC" +
            "EB7AB2A6B60C27C69317BD7AB2135F50C6317E5DBFB9D1E55936E4109B7B" +
            "911450C746FE0D5D07165B6B23ADA7700B0033238C858AD179A82459C471" +
            "8019C111B4EF7BE53E5972E06CA68A112406DA38CF60D2F4FDA4D1CD52F1" +
            "DA9FD6104D91A34455CD7B328B02525320A35253147BE0B7A5BC860966DC" +
            "84F10D723CE7EED5430203010001";

        public static void Main(string[] args)
        {
            // Set callback (deleagte)
            ServicePointManager.ServerCertificateValidationCallback = PinPublicKey;

            // Request
            WebRequest request = WebRequest.Create("https://www.random.org/integers/?" +
                "num=16&min=0&max=255&col=16&base=16&format=plain&rnd=new");
            request.Timeout = 10000 /*milliseconds*/;

            // Response
            WebResponse response = request.GetResponse();

            // Get the stream associated with the response.
            using (Stream stream = response.GetResponseStream())
            {
                // Pipes the stream to a higher level stream reader with the required encoding format. 
                using (StreamReader reader = new StreamReader(stream, Encoding.UTF8))
                {
                    Console.WriteLine(reader.ReadToEnd());
                }
            }
        }

        public static bool PinPublicKey(object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors sslPolicyErrors)
        {
            if (certificate == null || chain == null)
                return false;

            if (sslPolicyErrors != SslPolicyErrors.None)
                return false;

            // Verify against known public key within the certificate
            String pk = certificate.GetPublicKeyString();
            if (pk.Equals(PUB_KEY))
                return true;

            return false;
        }
    }
}
